﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Reflection;

namespace AHOBPR_WcfService.BaseCode
{
    public static class WebSiteVersion
    {
        public static Version BuildVersion
        {
            get
            {
                DateTime buildDate = BuildDate;
                DateTime baseDate = new DateTime(2000, 1, 1, 0, 0, 0);
                DateTime baseTime = new DateTime(buildDate.Year, buildDate.Month, buildDate.Day, 0, 0, 0);

                TimeSpan dateSpan = buildDate.Subtract(baseDate); //Days since 1/1/2000
                TimeSpan timeSpan = buildDate.Subtract(baseTime); //Seconds since mid-night / 2

                int days = (int)dateSpan.TotalDays;
                int secs = ((int)timeSpan.TotalSeconds) / 2;

                return new Version("4.4.17.10");// + secs.ToString());
            }
        }
        public static DateTime BuildDate
        {
            get
            {
                Assembly current = Assembly.GetExecutingAssembly();
                return VeteransAffairs.Registries.Business.Utilities.AssemblyTime.Get(current.Location);
            }
        }
    }
}